<?php
/*
 * Alter
 * @author   AcmeeDesign
 * @url     http://acmeedesign.com
*/

defined('ABSPATH') || die;

class ALTERTHENES extends ALTER
{

    function __construct()
    {
      $this->aof_options = parent::alter_get_option_data(ALTER_OPTIONS_SLUG);
      add_action('admin_menu', array($this, 'alter_themes_menu'));
      add_action('plugins_loaded',array($this, 'alter_import_theme'));
    }

    function alter_themes_menu()
    {
      add_submenu_page( ALTER_MENU_SLUG , __('Alter Themes', 'alter'), __('Alter Themes', 'alter'), 'manage_options', 'alter_themes', array($this,'alter_theme_content') );
    }

    function alter_theme_content()
    {
        global $aof_options;
        $aof_options->licenseValidate();
        $alter_themes = $this->alter_themes();
    ?>
    <div class="wrap alter_themes">
      <h2><?php echo __('Change Theme', 'alter'); ?></h2>
      <p><strong><?php echo __( 'Note: By changing the theme will replace your existing custom set colors.', 'alter') ?></strong></p>
    <?php
    $get_alter_data = parent::alter_get_option_data(ALTER_OPTIONS_SLUG);
    $selected_theme = (isset($get_alter_data['current_theme'])) ? $get_alter_data['current_theme'] : "";
    if(isset($_GET['status']) && $_GET['status'] == 'updated') {
      echo '<div id="message" class="updated below-h2"><p>';
      echo $selected_theme . " " . __( 'theme Imported!' );
      echo '</p></div>';
    }
    ?>
      <form name="alter_set_theme" method="post" action="">
        <div class="form-table">
    <?php
        foreach ($alter_themes as $theme_name => $theme_color) {
          $theme_color_data = unserialize($theme_color);
    ?>
          <div class="color_box">
            <div class="color-option <?php if($theme_name == $selected_theme) echo 'current-theme'; ?>" style="width:100%">
              <div class="color-palette-wrap">
                <table class="color-palette">
                  <tbody>
                    <tr>
                      <td style="background-color: <?php echo $theme_color_data['admin_bar_color']; ?>">&nbsp;</td>
                      <td style="background-color: <?php echo $theme_color_data['nav_wrap_color']; ?>">&nbsp;</td>
                      <td style="background-color: <?php echo $theme_color_data['active_menu_color']; ?>">&nbsp;</td>
                      <td style="background-color: <?php echo $theme_color_data['pry_button_color']; ?>">&nbsp;</td>
                      <td style="background-color: <?php echo $theme_color_data['sec_button_color']; ?>">&nbsp;</td>
                    </tr>
                  </tbody>
                </table>
              </div>
            <div class="theme_name">
              <input type="radio" name="alter_color_theme" value="<?php echo $theme_name; ?>" <?php if($theme_name == $selected_theme) echo 'checked="checked"'; ?> />
              <label for="<?php echo $theme_name; ?>"><?php echo $theme_name; ?></label>
            </div>
            </div>
          </div>
    <?php

            }
    ?>

        </div>
        <input type="submit" class="button button-primary" name="submit" value="<?php echo __('Import Theme', 'alter'); ?>" />
        <?php wp_nonce_field('alter_import_theme_nonce','alter_import_theme_field'); ?>
      </form>
    </div>
    <?php
      }

      function alter_import_theme()
      {
        if( isset($_POST['alter_import_theme_field']) && isset($_POST['alter_color_theme']) ) {
          if(!wp_verify_nonce( $_POST['alter_import_theme_field'], 'alter_import_theme_nonce' ) )
            exit();
          $alter_themes = $this->alter_themes();
          $selected_theme = trim($_POST['alter_color_theme']);
          $chosen_theme = unserialize($alter_themes[$selected_theme]);
          $current_theme = array('current_theme' => $selected_theme);
          $theme_data = array_merge($chosen_theme, $current_theme);
          $saved_data = parent::alter_get_option_data(ALTER_OPTIONS_SLUG);
          $data = array_merge($saved_data, $theme_data);
          parent::updateOption(ALTER_OPTIONS_SLUG, $data);
          wp_safe_redirect( admin_url( 'admin.php?page=alter_themes&status=updated' ) );
          exit();
        }
      }

            function alter_themes()
            {

              $alter_themes = array();

              $alter_themes['sleek'] = 'a:52:{s:8:"bg_color";s:7:"#e8e8e8";s:8:"h1_color";s:7:"#333333";s:8:"h2_color";s:7:"#222222";s:8:"h3_color";s:7:"#222222";s:8:"h4_color";s:7:"#555555";s:8:"h5_color";s:7:"#555555";s:8:"h6_color";s:7:"#555555";s:14:"login_bg_color";s:7:"#263237";s:23:"login_inputs_text_color";s:7:"#5b5b5b";s:25:"login_inputs_border_color";s:7:"#e2e2e2";s:31:"login_inputs_border_hover_color";s:7:"#756c6c";s:18:"login_formbg_color";s:7:"#423143";s:17:"form_border_color";s:7:"#e5e5e5";s:15:"form_text_color";s:7:"#cccccc";s:15:"form_link_color";s:7:"#777777";s:21:"form_link_hover_color";s:7:"#555555";s:23:"admin_bar_logo_bg_color";s:7:"#ffffff";s:15:"admin_bar_color";s:7:"#1c1e26";s:20:"admin_bar_menu_color";s:7:"#bfc3c9";s:26:"admin_bar_menu_hover_color";s:7:"#ffffff";s:29:"admin_bar_menu_bg_hover_color";s:7:"#21242d";s:27:"admin_bar_sbmenu_link_color";s:7:"#bfc3c9";s:33:"admin_bar_sbmenu_link_hover_color";s:7:"#313131";s:16:"pry_button_color";s:7:"#e84a4a";s:21:"pry_button_text_color";s:7:"#ffffff";s:22:"pry_button_hover_color";s:7:"#e84e4e";s:27:"pry_button_hover_text_color";s:7:"#ffffff";s:16:"sec_button_color";s:7:"#ffffff";s:21:"sec_button_text_color";s:7:"#8e96a0";s:22:"sec_button_hover_color";s:7:"#bec3c6";s:27:"sec_button_hover_text_color";s:7:"#ffffff";s:16:"metabox_h3_color";s:7:"#ffffff";s:23:"metabox_h3_border_color";s:7:"#e2e7ec";s:20:"metabox_handle_color";s:7:"#8e96a0";s:26:"metabox_handle_hover_color";s:7:"#787e87";s:18:"metabox_text_color";s:7:"#8e96a0";s:13:"msg_box_color";s:7:"#62be8b";s:17:"msgbox_text_color";s:7:"#ffffff";s:19:"msgbox_border_color";s:7:"#165b34";s:17:"msgbox_link_color";s:7:"#1f7547";s:23:"msgbox_link_hover_color";s:7:"#3a8e60";s:14:"nav_wrap_color";s:7:"#282c37";s:18:"sub_nav_wrap_color";s:7:"#20222e";s:14:"nav_text_color";s:7:"#8aa0a0";s:16:"hover_menu_color";s:7:"#313541";s:21:"menu_hover_text_color";s:7:"#cecece";s:17:"active_menu_color";s:7:"#e84a4a";s:22:"menu_active_text_color";s:7:"#cecece";s:25:"submenu_active_text_color";s:7:"#cecece";s:20:"menu_separator_color";s:7:"#141b21";s:21:"menu_updates_count_bg";s:7:"#e84a4a";s:23:"menu_updates_count_text";s:7:"#ffffff";}';

              $alter_themes['slate'] = 'a:52:{s:8:"bg_color";s:7:"#e8e8e8";s:8:"h1_color";s:7:"#333333";s:8:"h2_color";s:7:"#222222";s:8:"h3_color";s:7:"#222222";s:8:"h4_color";s:7:"#555555";s:8:"h5_color";s:7:"#555555";s:8:"h6_color";s:7:"#555555";s:14:"login_bg_color";s:7:"#263237";s:23:"login_inputs_text_color";s:7:"#5b5b5b";s:25:"login_inputs_border_color";s:7:"#e2e2e2";s:31:"login_inputs_border_hover_color";s:7:"#756c6c";s:18:"login_formbg_color";s:7:"#423143";s:17:"form_border_color";s:7:"#e5e5e5";s:15:"form_text_color";s:7:"#cccccc";s:15:"form_link_color";s:7:"#777777";s:21:"form_link_hover_color";s:7:"#555555";s:23:"admin_bar_logo_bg_color";s:7:"#ffffff";s:15:"admin_bar_color";s:7:"#2a2e35";s:20:"admin_bar_menu_color";s:7:"#b7bbcc";s:26:"admin_bar_menu_hover_color";s:7:"#ffffff";s:29:"admin_bar_menu_bg_hover_color";s:7:"#363b44";s:27:"admin_bar_sbmenu_link_color";s:7:"#f4f4f4";s:33:"admin_bar_sbmenu_link_hover_color";s:7:"#313131";s:16:"pry_button_color";s:7:"#5b606d";s:21:"pry_button_text_color";s:7:"#ffffff";s:22:"pry_button_hover_color";s:7:"#717a8c";s:27:"pry_button_hover_text_color";s:7:"#fcfcfc";s:16:"sec_button_color";s:7:"#ffffff";s:21:"sec_button_text_color";s:7:"#5b606d";s:22:"sec_button_hover_color";s:7:"#5b606d";s:27:"sec_button_hover_text_color";s:7:"#ffffff";s:16:"metabox_h3_color";s:7:"#ffffff";s:23:"metabox_h3_border_color";s:7:"#eeeeee";s:20:"metabox_handle_color";s:7:"#595959";s:26:"metabox_handle_hover_color";s:7:"#444444";s:18:"metabox_text_color";s:7:"#565656";s:13:"msg_box_color";s:7:"#5b606d";s:17:"msgbox_text_color";s:7:"#cfd2d7";s:19:"msgbox_border_color";s:7:"#252931";s:17:"msgbox_link_color";s:7:"#e6eaef";s:23:"msgbox_link_hover_color";s:7:"#252931";s:14:"nav_wrap_color";s:7:"#5b606d";s:18:"sub_nav_wrap_color";s:7:"#252931";s:14:"nav_text_color";s:7:"#cfd2d7";s:16:"hover_menu_color";s:7:"#3d434d";s:21:"menu_hover_text_color";s:7:"#cfd2d7";s:17:"active_menu_color";s:7:"#3d434d";s:22:"menu_active_text_color";s:7:"#cecece";s:25:"submenu_active_text_color";s:7:"#cecece";s:20:"menu_separator_color";s:7:"#141b21";s:21:"menu_updates_count_bg";s:7:"#2d2d2d";s:23:"menu_updates_count_text";s:7:"#ffffff";}';

              $alter_themes['Hive'] = 'a:52:{s:8:"bg_color";s:7:"#e8e8e8";s:8:"h1_color";s:7:"#333333";s:8:"h2_color";s:7:"#222222";s:8:"h3_color";s:7:"#222222";s:8:"h4_color";s:7:"#555555";s:8:"h5_color";s:7:"#555555";s:8:"h6_color";s:7:"#555555";s:14:"login_bg_color";s:7:"#263237";s:23:"login_inputs_text_color";s:7:"#5b5b5b";s:25:"login_inputs_border_color";s:7:"#e2e2e2";s:31:"login_inputs_border_hover_color";s:7:"#756c6c";s:18:"login_formbg_color";s:7:"#423143";s:17:"form_border_color";s:7:"#e5e5e5";s:15:"form_text_color";s:7:"#cccccc";s:15:"form_link_color";s:7:"#777777";s:21:"form_link_hover_color";s:7:"#555555";s:23:"admin_bar_logo_bg_color";s:7:"#ffffff";s:15:"admin_bar_color";s:7:"#3c3f3f";s:20:"admin_bar_menu_color";s:7:"#f2faff";s:26:"admin_bar_menu_hover_color";s:7:"#ffffff";s:29:"admin_bar_menu_bg_hover_color";s:7:"#4b4f4f";s:27:"admin_bar_sbmenu_link_color";s:7:"#f4f4f4";s:33:"admin_bar_sbmenu_link_hover_color";s:7:"#313131";s:16:"pry_button_color";s:7:"#d3ae08";s:21:"pry_button_text_color";s:7:"#352000";s:22:"pry_button_hover_color";s:7:"#f4c713";s:27:"pry_button_hover_text_color";s:7:"#352000";s:16:"sec_button_color";s:7:"#fafbfe";s:21:"sec_button_text_color";s:7:"#8e8e8e";s:22:"sec_button_hover_color";s:7:"#f2f2f2";s:27:"sec_button_hover_text_color";s:7:"#757575";s:16:"metabox_h3_color";s:7:"#ffffff";s:23:"metabox_h3_border_color";s:7:"#ffffff";s:20:"metabox_handle_color";s:7:"#595959";s:26:"metabox_handle_hover_color";s:7:"#444444";s:18:"metabox_text_color";s:7:"#565656";s:13:"msg_box_color";s:7:"#2b3133";s:17:"msgbox_text_color";s:7:"#bec4c4";s:19:"msgbox_border_color";s:7:"#d3ae08";s:17:"msgbox_link_color";s:7:"#d3ae08";s:23:"msgbox_link_hover_color";s:7:"#af8300";s:14:"nav_wrap_color";s:7:"#ede221";s:18:"sub_nav_wrap_color";s:7:"#f4c713";s:14:"nav_text_color";s:7:"#6b5700";s:16:"hover_menu_color";s:7:"#dbb304";s:21:"menu_hover_text_color";s:7:"#0a0a0a";s:17:"active_menu_color";s:7:"#d3ae08";s:22:"menu_active_text_color";s:7:"#cecece";s:25:"submenu_active_text_color";s:7:"#cecece";s:20:"menu_separator_color";s:7:"#141b21";s:21:"menu_updates_count_bg";s:7:"#3c3f3f";s:23:"menu_updates_count_text";s:7:"#ffffff";}';

              $alter_themes['Grass'] = 'a:52:{s:8:"bg_color";s:7:"#e8e8e8";s:8:"h1_color";s:7:"#333333";s:8:"h2_color";s:7:"#222222";s:8:"h3_color";s:7:"#222222";s:8:"h4_color";s:7:"#555555";s:8:"h5_color";s:7:"#555555";s:8:"h6_color";s:7:"#555555";s:14:"login_bg_color";s:7:"#263237";s:23:"login_inputs_text_color";s:7:"#5b5b5b";s:25:"login_inputs_border_color";s:7:"#e2e2e2";s:31:"login_inputs_border_hover_color";s:7:"#756c6c";s:18:"login_formbg_color";s:7:"#423143";s:17:"form_border_color";s:7:"#e5e5e5";s:15:"form_text_color";s:7:"#cccccc";s:15:"form_link_color";s:7:"#777777";s:21:"form_link_hover_color";s:7:"#555555";s:23:"admin_bar_logo_bg_color";s:7:"#ffffff";s:15:"admin_bar_color";s:7:"#eeffe2";s:20:"admin_bar_menu_color";s:7:"#699651";s:26:"admin_bar_menu_hover_color";s:7:"#426836";s:29:"admin_bar_menu_bg_hover_color";s:7:"#daeace";s:27:"admin_bar_sbmenu_link_color";s:7:"#666666";s:33:"admin_bar_sbmenu_link_hover_color";s:7:"#313131";s:16:"pry_button_color";s:7:"#96cc70";s:21:"pry_button_text_color";s:7:"#364c23";s:22:"pry_button_hover_color";s:7:"#b2cca3";s:27:"pry_button_hover_text_color";s:7:"#446b2e";s:16:"sec_button_color";s:7:"#fafbfe";s:21:"sec_button_text_color";s:7:"#76a349";s:22:"sec_button_hover_color";s:7:"#76a349";s:27:"sec_button_hover_text_color";s:7:"#ffffff";s:16:"metabox_h3_color";s:7:"#ffffff";s:23:"metabox_h3_border_color";s:7:"#ffffff";s:20:"metabox_handle_color";s:7:"#595959";s:26:"metabox_handle_hover_color";s:7:"#444444";s:18:"metabox_text_color";s:7:"#565656";s:13:"msg_box_color";s:7:"#ffffff";s:17:"msgbox_text_color";s:7:"#848484";s:19:"msgbox_border_color";s:7:"#96cc70";s:17:"msgbox_link_color";s:7:"#76a349";s:23:"msgbox_link_hover_color";s:7:"#357515";s:14:"nav_wrap_color";s:7:"#96cc70";s:18:"sub_nav_wrap_color";s:7:"#84b262";s:14:"nav_text_color";s:7:"#364c23";s:16:"hover_menu_color";s:7:"#84b262";s:21:"menu_hover_text_color";s:7:"#507a34";s:17:"active_menu_color";s:7:"#6b904f";s:22:"menu_active_text_color";s:7:"#cecece";s:25:"submenu_active_text_color";s:7:"#cecece";s:20:"menu_separator_color";s:7:"#141b21";s:21:"menu_updates_count_bg";s:7:"#364c23";s:23:"menu_updates_count_text";s:7:"#ffffff";}';

              $alter_themes['Blueberry'] = 'a:52:{s:8:"bg_color";s:7:"#f3f5fa";s:8:"h1_color";s:7:"#333333";s:8:"h2_color";s:7:"#222222";s:8:"h3_color";s:7:"#222222";s:8:"h4_color";s:7:"#555555";s:8:"h5_color";s:7:"#555555";s:8:"h6_color";s:7:"#555555";s:14:"login_bg_color";s:7:"#263237";s:23:"login_inputs_text_color";s:7:"#5b5b5b";s:25:"login_inputs_border_color";s:7:"#e2e2e2";s:31:"login_inputs_border_hover_color";s:7:"#756c6c";s:18:"login_formbg_color";s:7:"#423143";s:17:"form_border_color";s:7:"#e5e5e5";s:15:"form_text_color";s:7:"#cccccc";s:15:"form_link_color";s:7:"#777777";s:21:"form_link_hover_color";s:7:"#555555";s:23:"admin_bar_logo_bg_color";s:7:"#ffffff";s:15:"admin_bar_color";s:7:"#60adf1";s:20:"admin_bar_menu_color";s:7:"#e8edf9";s:26:"admin_bar_menu_hover_color";s:7:"#ffffff";s:29:"admin_bar_menu_bg_hover_color";s:7:"#559cdb";s:27:"admin_bar_sbmenu_link_color";s:7:"#515151";s:33:"admin_bar_sbmenu_link_hover_color";s:7:"#313131";s:16:"pry_button_color";s:7:"#60adf1";s:21:"pry_button_text_color";s:7:"#ffffff";s:22:"pry_button_hover_color";s:7:"#48a3f2";s:27:"pry_button_hover_text_color";s:7:"#ffffff";s:16:"sec_button_color";s:7:"#fafbfe";s:21:"sec_button_text_color";s:7:"#8c96b1";s:22:"sec_button_hover_color";s:7:"#ffffff";s:27:"sec_button_hover_text_color";s:7:"#7b829e";s:16:"metabox_h3_color";s:7:"#e8ecf5";s:23:"metabox_h3_border_color";s:7:"#ced9e3";s:20:"metabox_handle_color";s:7:"#68718a";s:26:"metabox_handle_hover_color";s:7:"#414c75";s:18:"metabox_text_color";s:7:"#68718a";s:13:"msg_box_color";s:7:"#dce1eb";s:17:"msgbox_text_color";s:7:"#9ca5bc";s:19:"msgbox_border_color";s:7:"#69cdbf";s:17:"msgbox_link_color";s:7:"#81869e";s:23:"msgbox_link_hover_color";s:7:"#69cdbf";s:14:"nav_wrap_color";s:7:"#727f9e";s:18:"sub_nav_wrap_color";s:7:"#5b6282";s:14:"nav_text_color";s:7:"#d7dbe7";s:16:"hover_menu_color";s:7:"#525e7f";s:21:"menu_hover_text_color";s:7:"#d7dbe7";s:17:"active_menu_color";s:7:"#60adf1";s:22:"menu_active_text_color";s:7:"#cecece";s:25:"submenu_active_text_color";s:7:"#cecece";s:20:"menu_separator_color";s:7:"#5b6282";s:21:"menu_updates_count_bg";s:7:"#414c75";s:23:"menu_updates_count_text";s:7:"#d7dbe7";}';

              $alter_themes['Blossoms'] = 'a:52:{s:8:"bg_color";s:7:"#eeebe5";s:8:"h1_color";s:7:"#333333";s:8:"h2_color";s:7:"#222222";s:8:"h3_color";s:7:"#222222";s:8:"h4_color";s:7:"#555555";s:8:"h5_color";s:7:"#555555";s:8:"h6_color";s:7:"#555555";s:14:"login_bg_color";s:7:"#263237";s:23:"login_inputs_text_color";s:7:"#5b5b5b";s:25:"login_inputs_border_color";s:7:"#e2e2e2";s:31:"login_inputs_border_hover_color";s:7:"#756c6c";s:18:"login_formbg_color";s:7:"#423143";s:17:"form_border_color";s:7:"#e5e5e5";s:15:"form_text_color";s:7:"#cccccc";s:15:"form_link_color";s:7:"#777777";s:21:"form_link_hover_color";s:7:"#555555";s:23:"admin_bar_logo_bg_color";s:7:"#ffffff";s:15:"admin_bar_color";s:7:"#e3d7e9";s:20:"admin_bar_menu_color";s:7:"#af76bc";s:26:"admin_bar_menu_hover_color";s:7:"#86588c";s:29:"admin_bar_menu_bg_hover_color";s:7:"#d0c7d6";s:27:"admin_bar_sbmenu_link_color";s:7:"#515151";s:33:"admin_bar_sbmenu_link_hover_color";s:7:"#313131";s:16:"pry_button_color";s:7:"#5783bb";s:21:"pry_button_text_color";s:7:"#ffffff";s:22:"pry_button_hover_color";s:7:"#6795db";s:27:"pry_button_hover_text_color";s:7:"#fcfcfc";s:16:"sec_button_color";s:7:"#ffffff";s:21:"sec_button_text_color";s:7:"#8551a5";s:22:"sec_button_hover_color";s:7:"#8551a5";s:27:"sec_button_hover_text_color";s:7:"#ffffff";s:16:"metabox_h3_color";s:7:"#ffffff";s:23:"metabox_h3_border_color";s:7:"#eeeeee";s:20:"metabox_handle_color";s:7:"#595959";s:26:"metabox_handle_hover_color";s:7:"#444444";s:18:"metabox_text_color";s:7:"#565656";s:13:"msg_box_color";s:7:"#ffffff";s:17:"msgbox_text_color";s:7:"#848484";s:19:"msgbox_border_color";s:7:"#8551a5";s:17:"msgbox_link_color";s:7:"#2b0742";s:23:"msgbox_link_hover_color";s:7:"#8551a5";s:14:"nav_wrap_color";s:7:"#8551a5";s:18:"sub_nav_wrap_color";s:7:"#683c87";s:14:"nav_text_color";s:7:"#e3d7e9";s:16:"hover_menu_color";s:7:"#592e70";s:21:"menu_hover_text_color";s:7:"#e3d7e9";s:17:"active_menu_color";s:7:"#592e70";s:22:"menu_active_text_color";s:7:"#cecece";s:25:"submenu_active_text_color";s:7:"#cecece";s:20:"menu_separator_color";s:7:"#683c87";s:21:"menu_updates_count_bg";s:7:"#3c1a4c";s:23:"menu_updates_count_text";s:7:"#e3d7e9";}';

              $alter_themes['Sugar Cane'] = 'a:52:{s:8:"bg_color";s:7:"#e8e8e8";s:8:"h1_color";s:7:"#333333";s:8:"h2_color";s:7:"#222222";s:8:"h3_color";s:7:"#222222";s:8:"h4_color";s:7:"#555555";s:8:"h5_color";s:7:"#555555";s:8:"h6_color";s:7:"#555555";s:14:"login_bg_color";s:7:"#263237";s:23:"login_inputs_text_color";s:7:"#5b5b5b";s:25:"login_inputs_border_color";s:7:"#e2e2e2";s:31:"login_inputs_border_hover_color";s:7:"#756c6c";s:18:"login_formbg_color";s:7:"#423143";s:17:"form_border_color";s:7:"#e5e5e5";s:15:"form_text_color";s:7:"#cccccc";s:15:"form_link_color";s:7:"#777777";s:21:"form_link_hover_color";s:7:"#555555";s:23:"admin_bar_logo_bg_color";s:7:"#ffffff";s:15:"admin_bar_color";s:7:"#ffffff";s:20:"admin_bar_menu_color";s:7:"#94979b";s:26:"admin_bar_menu_hover_color";s:7:"#474747";s:29:"admin_bar_menu_bg_hover_color";s:7:"#eae3e3";s:27:"admin_bar_sbmenu_link_color";s:7:"#424242";s:33:"admin_bar_sbmenu_link_hover_color";s:7:"#313131";s:16:"pry_button_color";s:7:"#7ac600";s:21:"pry_button_text_color";s:7:"#ffffff";s:22:"pry_button_hover_color";s:7:"#29ac39";s:27:"pry_button_hover_text_color";s:7:"#ffffff";s:16:"sec_button_color";s:7:"#c9c8bf";s:21:"sec_button_text_color";s:7:"#ffffff";s:22:"sec_button_hover_color";s:7:"#b7b6ae";s:27:"sec_button_hover_text_color";s:7:"#ffffff";s:16:"metabox_h3_color";s:7:"#4cbceb";s:23:"metabox_h3_border_color";s:7:"#46b0dd";s:20:"metabox_handle_color";s:7:"#91f5ff";s:26:"metabox_handle_hover_color";s:7:"#ffffff";s:18:"metabox_text_color";s:7:"#ffffff";s:13:"msg_box_color";s:7:"#02c5cc";s:17:"msgbox_text_color";s:7:"#ffffff";s:19:"msgbox_border_color";s:7:"#007e87";s:17:"msgbox_link_color";s:7:"#efefef";s:23:"msgbox_link_hover_color";s:7:"#e5e5e5";s:14:"nav_wrap_color";s:7:"#282a3a";s:18:"sub_nav_wrap_color";s:7:"#373b4c";s:14:"nav_text_color";s:7:"#90a1a8";s:16:"hover_menu_color";s:7:"#2f313f";s:21:"menu_hover_text_color";s:7:"#ffffff";s:17:"active_menu_color";s:7:"#6da87a";s:22:"menu_active_text_color";s:7:"#cecece";s:25:"submenu_active_text_color";s:7:"#cecece";s:20:"menu_separator_color";s:7:"#141b21";s:21:"menu_updates_count_bg";s:7:"#e84a4a";s:23:"menu_updates_count_text";s:7:"#ffffff";}';

              $alter_themes['Beach'] = 'a:52:{s:8:"bg_color";s:7:"#ffffff";s:8:"h1_color";s:7:"#333333";s:8:"h2_color";s:7:"#222222";s:8:"h3_color";s:7:"#222222";s:8:"h4_color";s:7:"#555555";s:8:"h5_color";s:7:"#555555";s:8:"h6_color";s:7:"#555555";s:14:"login_bg_color";s:7:"#263237";s:23:"login_inputs_text_color";s:7:"#5b5b5b";s:25:"login_inputs_border_color";s:7:"#e2e2e2";s:31:"login_inputs_border_hover_color";s:7:"#756c6c";s:18:"login_formbg_color";s:7:"#423143";s:17:"form_border_color";s:7:"#e5e5e5";s:15:"form_text_color";s:7:"#cccccc";s:15:"form_link_color";s:7:"#777777";s:21:"form_link_hover_color";s:7:"#555555";s:23:"admin_bar_logo_bg_color";s:7:"#ffffff";s:15:"admin_bar_color";s:7:"#ffffff";s:20:"admin_bar_menu_color";s:7:"#0d9ddb";s:26:"admin_bar_menu_hover_color";s:7:"#0a80aa";s:29:"admin_bar_menu_bg_hover_color";s:7:"#e8e1e1";s:27:"admin_bar_sbmenu_link_color";s:7:"#515151";s:33:"admin_bar_sbmenu_link_hover_color";s:7:"#313131";s:16:"pry_button_color";s:7:"#e8c030";s:21:"pry_button_text_color";s:7:"#ffffff";s:22:"pry_button_hover_color";s:7:"#e8ca5f";s:27:"pry_button_hover_text_color";s:7:"#ffffff";s:16:"sec_button_color";s:7:"#fafbfe";s:21:"sec_button_text_color";s:7:"#5d6f7f";s:22:"sec_button_hover_color";s:7:"#5d6f7f";s:27:"sec_button_hover_text_color";s:7:"#ffffff";s:16:"metabox_h3_color";s:7:"#ffffff";s:23:"metabox_h3_border_color";s:7:"#eeeeee";s:20:"metabox_handle_color";s:7:"#595959";s:26:"metabox_handle_hover_color";s:7:"#444444";s:18:"metabox_text_color";s:7:"#565656";s:13:"msg_box_color";s:7:"#466485";s:17:"msgbox_text_color";s:7:"#f7f9ff";s:19:"msgbox_border_color";s:7:"#e8c030";s:17:"msgbox_link_color";s:7:"#e8c030";s:23:"msgbox_link_hover_color";s:7:"#ffffff";s:14:"nav_wrap_color";s:7:"#5199e6";s:18:"sub_nav_wrap_color";s:7:"#68abe5";s:14:"nav_text_color";s:7:"#f9f9f9";s:16:"hover_menu_color";s:7:"#68abe5";s:21:"menu_hover_text_color";s:7:"#eff4ff";s:17:"active_menu_color";s:7:"#e8c030";s:22:"menu_active_text_color";s:7:"#cecece";s:25:"submenu_active_text_color";s:7:"#cecece";s:20:"menu_separator_color";s:7:"#68abe5";s:21:"menu_updates_count_bg";s:7:"#ddb10f";s:23:"menu_updates_count_text";s:7:"#ffffff";}';

              $alter_themes['Africa'] = 'a:52:{s:8:"bg_color";s:7:"#fff8f4";s:8:"h1_color";s:7:"#333333";s:8:"h2_color";s:7:"#222222";s:8:"h3_color";s:7:"#222222";s:8:"h4_color";s:7:"#555555";s:8:"h5_color";s:7:"#555555";s:8:"h6_color";s:7:"#555555";s:14:"login_bg_color";s:7:"#263237";s:23:"login_inputs_text_color";s:7:"#5b5b5b";s:25:"login_inputs_border_color";s:7:"#e2e2e2";s:31:"login_inputs_border_hover_color";s:7:"#756c6c";s:18:"login_formbg_color";s:7:"#423143";s:17:"form_border_color";s:7:"#e5e5e5";s:15:"form_text_color";s:7:"#cccccc";s:15:"form_link_color";s:7:"#777777";s:21:"form_link_hover_color";s:7:"#555555";s:23:"admin_bar_logo_bg_color";s:7:"#ffffff";s:15:"admin_bar_color";s:7:"#c9b876";s:20:"admin_bar_menu_color";s:7:"#8e7c41";s:26:"admin_bar_menu_hover_color";s:7:"#75562e";s:29:"admin_bar_menu_bg_hover_color";s:7:"#b5a469";s:27:"admin_bar_sbmenu_link_color";s:7:"#515151";s:33:"admin_bar_sbmenu_link_hover_color";s:7:"#313131";s:16:"pry_button_color";s:7:"#d3b86e";s:21:"pry_button_text_color";s:7:"#3d2900";s:22:"pry_button_hover_color";s:7:"#cca770";s:27:"pry_button_hover_text_color";s:7:"#3d2900";s:16:"sec_button_color";s:7:"#f7f4f2";s:21:"sec_button_text_color";s:7:"#7f7171";s:22:"sec_button_hover_color";s:7:"#7f7171";s:27:"sec_button_hover_text_color";s:7:"#ffffff";s:16:"metabox_h3_color";s:7:"#ffffff";s:23:"metabox_h3_border_color";s:7:"#eeeeee";s:20:"metabox_handle_color";s:7:"#595959";s:26:"metabox_handle_hover_color";s:7:"#444444";s:18:"metabox_text_color";s:7:"#565656";s:13:"msg_box_color";s:7:"#2d2925";s:17:"msgbox_text_color";s:7:"#d3b86e";s:19:"msgbox_border_color";s:7:"#baa25e";s:17:"msgbox_link_color";s:7:"#edd27b";s:23:"msgbox_link_hover_color";s:7:"#9b8549";s:14:"nav_wrap_color";s:7:"#2d2925";s:18:"sub_nav_wrap_color";s:7:"#c9b876";s:14:"nav_text_color";s:7:"#9b8549";s:16:"hover_menu_color";s:7:"#3d2900";s:21:"menu_hover_text_color";s:7:"#eff4ff";s:17:"active_menu_color";s:7:"#baa25e";s:22:"menu_active_text_color";s:7:"#cecece";s:25:"submenu_active_text_color";s:7:"#cecece";s:20:"menu_separator_color";s:7:"#c9b876";s:21:"menu_updates_count_bg";s:7:"#ba993f";s:23:"menu_updates_count_text";s:7:"#2d2925";}';

              $alter_themes['Military'] = 'a:52:{s:8:"bg_color";s:7:"#efeff1";s:8:"h1_color";s:7:"#333333";s:8:"h2_color";s:7:"#222222";s:8:"h3_color";s:7:"#222222";s:8:"h4_color";s:7:"#555555";s:8:"h5_color";s:7:"#555555";s:8:"h6_color";s:7:"#555555";s:14:"login_bg_color";s:7:"#263237";s:23:"login_inputs_text_color";s:7:"#5b5b5b";s:25:"login_inputs_border_color";s:7:"#e2e2e2";s:31:"login_inputs_border_hover_color";s:7:"#756c6c";s:18:"login_formbg_color";s:7:"#423143";s:17:"form_border_color";s:7:"#e5e5e5";s:15:"form_text_color";s:7:"#cccccc";s:15:"form_link_color";s:7:"#777777";s:21:"form_link_hover_color";s:7:"#555555";s:23:"admin_bar_logo_bg_color";s:7:"#ffffff";s:15:"admin_bar_color";s:7:"#ffffff";s:20:"admin_bar_menu_color";s:7:"#383838";s:26:"admin_bar_menu_hover_color";s:7:"#1c1c1c";s:29:"admin_bar_menu_bg_hover_color";s:7:"#eaeaea";s:27:"admin_bar_sbmenu_link_color";s:7:"#5b5b5b";s:33:"admin_bar_sbmenu_link_hover_color";s:7:"#313131";s:16:"pry_button_color";s:7:"#7e843f";s:21:"pry_button_text_color";s:7:"#ffffff";s:22:"pry_button_hover_color";s:7:"#6d7237";s:27:"pry_button_hover_text_color";s:7:"#f9f9f9";s:16:"sec_button_color";s:7:"#968b4f";s:21:"sec_button_text_color";s:7:"#ffffff";s:22:"sec_button_hover_color";s:7:"#848044";s:27:"sec_button_hover_text_color";s:7:"#ffffff";s:16:"metabox_h3_color";s:7:"#efefef";s:23:"metabox_h3_border_color";s:7:"#dddddd";s:20:"metabox_handle_color";s:7:"#595959";s:26:"metabox_handle_hover_color";s:7:"#444444";s:18:"metabox_text_color";s:7:"#565656";s:13:"msg_box_color";s:7:"#d5dbc7";s:17:"msgbox_text_color";s:7:"#565644";s:19:"msgbox_border_color";s:7:"#90965b";s:17:"msgbox_link_color";s:7:"#525403";s:23:"msgbox_link_hover_color";s:7:"#332b00";s:14:"nav_wrap_color";s:7:"#58573b";s:18:"sub_nav_wrap_color";s:7:"#44402d";s:14:"nav_text_color";s:7:"#ffffff";s:16:"hover_menu_color";s:7:"#90965b";s:21:"menu_hover_text_color";s:7:"#ffffff";s:17:"active_menu_color";s:7:"#808450";s:22:"menu_active_text_color";s:7:"#ffffff";s:25:"submenu_active_text_color";s:7:"#cecece";s:20:"menu_separator_color";s:7:"#44402d";s:21:"menu_updates_count_bg";s:7:"#f2f4ef";s:23:"menu_updates_count_text";s:7:"#3a3300";}';

              $alter_themes['Paper and clay'] = 'a:52:{s:8:"bg_color";s:7:"#f2e5d7";s:8:"h1_color";s:7:"#333333";s:8:"h2_color";s:7:"#222222";s:8:"h3_color";s:7:"#222222";s:8:"h4_color";s:7:"#555555";s:8:"h5_color";s:7:"#555555";s:8:"h6_color";s:7:"#555555";s:14:"login_bg_color";s:7:"#263237";s:23:"login_inputs_text_color";s:7:"#5b5b5b";s:25:"login_inputs_border_color";s:7:"#e2e2e2";s:31:"login_inputs_border_hover_color";s:7:"#756c6c";s:18:"login_formbg_color";s:7:"#423143";s:17:"form_border_color";s:7:"#e5e5e5";s:15:"form_text_color";s:7:"#cccccc";s:15:"form_link_color";s:7:"#777777";s:21:"form_link_hover_color";s:7:"#555555";s:23:"admin_bar_logo_bg_color";s:7:"#ffffff";s:15:"admin_bar_color";s:7:"#ba9f86";s:20:"admin_bar_menu_color";s:7:"#ffffff";s:26:"admin_bar_menu_hover_color";s:7:"#f4e9cd";s:29:"admin_bar_menu_bg_hover_color";s:7:"#28a07e";s:27:"admin_bar_sbmenu_link_color";s:7:"#e0e0e0";s:33:"admin_bar_sbmenu_link_hover_color";s:7:"#313131";s:16:"pry_button_color";s:7:"#7a4100";s:21:"pry_button_text_color";s:7:"#ffffff";s:22:"pry_button_hover_color";s:7:"#774d23";s:27:"pry_button_hover_text_color";s:7:"#ffffff";s:16:"sec_button_color";s:7:"#fafbfe";s:21:"sec_button_text_color";s:7:"#7f7171";s:22:"sec_button_hover_color";s:7:"#7f7171";s:27:"sec_button_hover_text_color";s:7:"#ffffff";s:16:"metabox_h3_color";s:7:"#ffffff";s:23:"metabox_h3_border_color";s:7:"#eeeeee";s:20:"metabox_handle_color";s:7:"#595959";s:26:"metabox_handle_hover_color";s:7:"#444444";s:18:"metabox_text_color";s:7:"#565656";s:13:"msg_box_color";s:7:"#ddc9b8";s:17:"msgbox_text_color";s:7:"#4f2b00";s:19:"msgbox_border_color";s:7:"#4f2b00";s:17:"msgbox_link_color";s:7:"#ffffff";s:23:"msgbox_link_hover_color";s:7:"#3a2600";s:14:"nav_wrap_color";s:7:"#e0d0c0";s:18:"sub_nav_wrap_color";s:7:"#ccb8a3";s:14:"nav_text_color";s:7:"#4f380b";s:16:"hover_menu_color";s:7:"#ccb7a1";s:21:"menu_hover_text_color";s:7:"#281e02";s:17:"active_menu_color";s:7:"#baa48f";s:22:"menu_active_text_color";s:7:"#cecece";s:25:"submenu_active_text_color";s:7:"#cecece";s:20:"menu_separator_color";s:7:"#ccb8a3";s:21:"menu_updates_count_bg";s:7:"#70583b";s:23:"menu_updates_count_text";s:7:"#f2e5d7";}';

              $alter_themes['Spring Kitchen'] = 'a:52:{s:8:"bg_color";s:7:"#a8aecf";s:8:"h1_color";s:7:"#333333";s:8:"h2_color";s:7:"#222222";s:8:"h3_color";s:7:"#222222";s:8:"h4_color";s:7:"#555555";s:8:"h5_color";s:7:"#555555";s:8:"h6_color";s:7:"#555555";s:14:"login_bg_color";s:7:"#263237";s:23:"login_inputs_text_color";s:7:"#5b5b5b";s:25:"login_inputs_border_color";s:7:"#e2e2e2";s:31:"login_inputs_border_hover_color";s:7:"#756c6c";s:18:"login_formbg_color";s:7:"#423143";s:17:"form_border_color";s:7:"#e5e5e5";s:15:"form_text_color";s:7:"#cccccc";s:15:"form_link_color";s:7:"#777777";s:21:"form_link_hover_color";s:7:"#555555";s:23:"admin_bar_logo_bg_color";s:7:"#ffffff";s:15:"admin_bar_color";s:7:"#a8aecf";s:20:"admin_bar_menu_color";s:7:"#e6f2ec";s:26:"admin_bar_menu_hover_color";s:7:"#474747";s:29:"admin_bar_menu_bg_hover_color";s:7:"#9aa0bc";s:27:"admin_bar_sbmenu_link_color";s:7:"#ffffff";s:33:"admin_bar_sbmenu_link_hover_color";s:7:"#313131";s:16:"pry_button_color";s:7:"#363732";s:21:"pry_button_text_color";s:7:"#ffffff";s:22:"pry_button_hover_color";s:7:"#6b6d63";s:27:"pry_button_hover_text_color";s:7:"#ffffff";s:16:"sec_button_color";s:7:"#74dbbf";s:21:"sec_button_text_color";s:7:"#595959";s:22:"sec_button_hover_color";s:7:"#70d39e";s:27:"sec_button_hover_text_color";s:7:"#595959";s:16:"metabox_h3_color";s:7:"#11293a";s:23:"metabox_h3_border_color";s:7:"#ffffff";s:20:"metabox_handle_color";s:7:"#d2dac3";s:26:"metabox_handle_hover_color";s:7:"#b8c0a7";s:18:"metabox_text_color";s:7:"#ffffff";s:13:"msg_box_color";s:7:"#d7b29d";s:17:"msgbox_text_color";s:7:"#ffffff";s:19:"msgbox_border_color";s:7:"#007e87";s:17:"msgbox_link_color";s:7:"#efefef";s:23:"msgbox_link_hover_color";s:7:"#e58e8e";s:14:"nav_wrap_color";s:7:"#ffffff";s:18:"sub_nav_wrap_color";s:7:"#f0f0f0";s:14:"nav_text_color";s:7:"#666666";s:16:"hover_menu_color";s:7:"#bababa";s:21:"menu_hover_text_color";s:7:"#ffffff";s:17:"active_menu_color";s:7:"#b4bfec";s:22:"menu_active_text_color";s:7:"#cecece";s:25:"submenu_active_text_color";s:7:"#cecece";s:20:"menu_separator_color";s:7:"#f0f0f0";s:21:"menu_updates_count_bg";s:7:"#212121";s:23:"menu_updates_count_text";s:7:"#ffffff";}';

              $alter_themes['Vitamin'] = 'a:52:{s:8:"bg_color";s:7:"#ffffff";s:8:"h1_color";s:7:"#333333";s:8:"h2_color";s:7:"#222222";s:8:"h3_color";s:7:"#222222";s:8:"h4_color";s:7:"#555555";s:8:"h5_color";s:7:"#555555";s:8:"h6_color";s:7:"#555555";s:14:"login_bg_color";s:7:"#263237";s:23:"login_inputs_text_color";s:7:"#5b5b5b";s:25:"login_inputs_border_color";s:7:"#e2e2e2";s:31:"login_inputs_border_hover_color";s:7:"#756c6c";s:18:"login_formbg_color";s:7:"#423143";s:17:"form_border_color";s:7:"#e5e5e5";s:15:"form_text_color";s:7:"#cccccc";s:15:"form_link_color";s:7:"#777777";s:21:"form_link_hover_color";s:7:"#555555";s:23:"admin_bar_logo_bg_color";s:7:"#ffffff";s:15:"admin_bar_color";s:7:"#ffffff";s:20:"admin_bar_menu_color";s:7:"#383838";s:26:"admin_bar_menu_hover_color";s:7:"#1c1c1c";s:29:"admin_bar_menu_bg_hover_color";s:7:"#e8e3e3";s:27:"admin_bar_sbmenu_link_color";s:7:"#777777";s:33:"admin_bar_sbmenu_link_hover_color";s:7:"#313131";s:16:"pry_button_color";s:7:"#ff470d";s:21:"pry_button_text_color";s:7:"#ffffff";s:22:"pry_button_hover_color";s:7:"#ff6030";s:27:"pry_button_hover_text_color";s:7:"#f9f9f9";s:16:"sec_button_color";s:7:"#f7f7f7";s:21:"sec_button_text_color";s:7:"#7f7f7f";s:22:"sec_button_hover_color";s:7:"#7f7f7f";s:27:"sec_button_hover_text_color";s:7:"#ffffff";s:16:"metabox_h3_color";s:7:"#ffffff";s:23:"metabox_h3_border_color";s:7:"#eeeeee";s:20:"metabox_handle_color";s:7:"#595959";s:26:"metabox_handle_hover_color";s:7:"#444444";s:18:"metabox_text_color";s:7:"#565656";s:13:"msg_box_color";s:7:"#efefef";s:17:"msgbox_text_color";s:7:"#383838";s:19:"msgbox_border_color";s:7:"#ff470d";s:17:"msgbox_link_color";s:7:"#2d2d2d";s:23:"msgbox_link_hover_color";s:7:"#00010a";s:14:"nav_wrap_color";s:7:"#383838";s:18:"sub_nav_wrap_color";s:7:"#1c1c1c";s:14:"nav_text_color";s:7:"#e8e8e8";s:16:"hover_menu_color";s:7:"#ff470d";s:21:"menu_hover_text_color";s:7:"#ffffff";s:17:"active_menu_color";s:7:"#ff470d";s:22:"menu_active_text_color";s:7:"#cecece";s:25:"submenu_active_text_color";s:7:"#cecece";s:20:"menu_separator_color";s:7:"#1c1c1c";s:21:"menu_updates_count_bg";s:7:"#ff470d";s:23:"menu_updates_count_text";s:7:"#f2fffb";}';

              $alter_themes['Baby Blue'] =
              'a:52:{s:8:"bg_color";s:7:"#c0d5f7";s:8:"h1_color";s:7:"#333333";s:8:"h2_color";s:7:"#222222";s:8:"h3_color";s:7:"#222222";s:8:"h4_color";s:7:"#555555";s:8:"h5_color";s:7:"#555555";s:8:"h6_color";s:7:"#555555";s:14:"login_bg_color";s:7:"#263237";s:23:"login_inputs_text_color";s:7:"#5b5b5b";s:25:"login_inputs_border_color";s:7:"#e2e2e2";s:31:"login_inputs_border_hover_color";s:7:"#756c6c";s:18:"login_formbg_color";s:7:"#423143";s:17:"form_border_color";s:7:"#e5e5e5";s:15:"form_text_color";s:7:"#cccccc";s:15:"form_link_color";s:7:"#777777";s:21:"form_link_hover_color";s:7:"#555555";s:23:"admin_bar_logo_bg_color";s:7:"#799dce";s:15:"admin_bar_color";s:7:"#ffffff";s:20:"admin_bar_menu_color";s:7:"#383838";s:26:"admin_bar_menu_hover_color";s:7:"#1c1c1c";s:29:"admin_bar_menu_bg_hover_color";s:7:"#e8e3e3";s:27:"admin_bar_sbmenu_link_color";s:7:"#777777";s:33:"admin_bar_sbmenu_link_hover_color";s:7:"#313131";s:16:"pry_button_color";s:7:"#28384f";s:21:"pry_button_text_color";s:7:"#ffffff";s:22:"pry_button_hover_color";s:7:"#1d2a3d";s:27:"pry_button_hover_text_color";s:7:"#f9f9f9";s:16:"sec_button_color";s:7:"#455a77";s:21:"sec_button_text_color";s:7:"#effffb";s:22:"sec_button_hover_color";s:7:"#2d4163";s:27:"sec_button_hover_text_color";s:7:"#ffffff";s:16:"metabox_h3_color";s:7:"#ffffff";s:23:"metabox_h3_border_color";s:7:"#eeeeee";s:20:"metabox_handle_color";s:7:"#595959";s:26:"metabox_handle_hover_color";s:7:"#444444";s:18:"metabox_text_color";s:7:"#565656";s:13:"msg_box_color";s:7:"#ffffff";s:17:"msgbox_text_color";s:7:"#3b4251";s:19:"msgbox_border_color";s:7:"#e8615e";s:17:"msgbox_link_color";s:7:"#233d89";s:23:"msgbox_link_hover_color";s:7:"#7582b2";s:14:"nav_wrap_color";s:7:"#799dce";s:18:"sub_nav_wrap_color";s:7:"#1f2635";s:14:"nav_text_color";s:7:"#ffffff";s:16:"hover_menu_color";s:7:"#8ca6d9";s:21:"menu_hover_text_color";s:7:"#ffffff";s:17:"active_menu_color";s:7:"#8bb7e0";s:22:"menu_active_text_color";s:7:"#cecece";s:25:"submenu_active_text_color";s:7:"#cecece";s:20:"menu_separator_color";s:7:"#8ca6d9";s:21:"menu_updates_count_bg";s:7:"#ffffff";s:23:"menu_updates_count_text";s:7:"#060d26";}';

              $alter_themes['Boat'] =
              'a:52:{s:8:"bg_color";s:7:"#f4f2ed";s:8:"h1_color";s:7:"#333333";s:8:"h2_color";s:7:"#222222";s:8:"h3_color";s:7:"#222222";s:8:"h4_color";s:7:"#555555";s:8:"h5_color";s:7:"#555555";s:8:"h6_color";s:7:"#555555";s:14:"login_bg_color";s:7:"#263237";s:23:"login_inputs_text_color";s:7:"#5b5b5b";s:25:"login_inputs_border_color";s:7:"#e2e2e2";s:31:"login_inputs_border_hover_color";s:7:"#756c6c";s:18:"login_formbg_color";s:7:"#423143";s:17:"form_border_color";s:7:"#e5e5e5";s:15:"form_text_color";s:7:"#cccccc";s:15:"form_link_color";s:7:"#777777";s:21:"form_link_hover_color";s:7:"#555555";s:23:"admin_bar_logo_bg_color";s:7:"#ffffff";s:15:"admin_bar_color";s:7:"#ffffff";s:20:"admin_bar_menu_color";s:7:"#383838";s:26:"admin_bar_menu_hover_color";s:7:"#1c1c1c";s:29:"admin_bar_menu_bg_hover_color";s:7:"#eaeaea";s:27:"admin_bar_sbmenu_link_color";s:7:"#5b5b5b";s:33:"admin_bar_sbmenu_link_hover_color";s:7:"#313131";s:16:"pry_button_color";s:7:"#ea5156";s:21:"pry_button_text_color";s:7:"#ffffff";s:22:"pry_button_hover_color";s:7:"#cc4b47";s:27:"pry_button_hover_text_color";s:7:"#f9f9f9";s:16:"sec_button_color";s:7:"#ffffff";s:21:"sec_button_text_color";s:7:"#b5433f";s:22:"sec_button_hover_color";s:7:"#d8494c";s:27:"sec_button_hover_text_color";s:7:"#ffffff";s:16:"metabox_h3_color";s:7:"#efefef";s:23:"metabox_h3_border_color";s:7:"#dddddd";s:20:"metabox_handle_color";s:7:"#595959";s:26:"metabox_handle_hover_color";s:7:"#444444";s:18:"metabox_text_color";s:7:"#565656";s:13:"msg_box_color";s:7:"#ffffff";s:17:"msgbox_text_color";s:7:"#505c68";s:19:"msgbox_border_color";s:7:"#d8494c";s:17:"msgbox_link_color";s:7:"#6285a6";s:23:"msgbox_link_hover_color";s:7:"#49657c";s:14:"nav_wrap_color";s:7:"#6285a6";s:18:"sub_nav_wrap_color";s:7:"#d8494c";s:14:"nav_text_color";s:7:"#ffffff";s:16:"hover_menu_color";s:7:"#ea5156";s:21:"menu_hover_text_color";s:7:"#ffffff";s:17:"active_menu_color";s:7:"#ea5156";s:22:"menu_active_text_color";s:7:"#ffffff";s:25:"submenu_active_text_color";s:7:"#cecece";s:20:"menu_separator_color";s:7:"#4f6f87";s:21:"menu_updates_count_bg";s:7:"#eb5153";s:23:"menu_updates_count_text";s:7:"#ffffff";}';

              $alter_themes['Dark Ocean'] =
              'a:52:{s:8:"bg_color";s:7:"#272c30";s:8:"h1_color";s:7:"#333333";s:8:"h2_color";s:7:"#222222";s:8:"h3_color";s:7:"#222222";s:8:"h4_color";s:7:"#555555";s:8:"h5_color";s:7:"#555555";s:8:"h6_color";s:7:"#555555";s:14:"login_bg_color";s:7:"#263237";s:23:"login_inputs_text_color";s:7:"#5b5b5b";s:25:"login_inputs_border_color";s:7:"#e2e2e2";s:31:"login_inputs_border_hover_color";s:7:"#756c6c";s:18:"login_formbg_color";s:7:"#423143";s:17:"form_border_color";s:7:"#e5e5e5";s:15:"form_text_color";s:7:"#cccccc";s:15:"form_link_color";s:7:"#777777";s:21:"form_link_hover_color";s:7:"#555555";s:23:"admin_bar_logo_bg_color";s:7:"#ffffff";s:15:"admin_bar_color";s:7:"#1c1e26";s:20:"admin_bar_menu_color";s:7:"#bfc3c9";s:26:"admin_bar_menu_hover_color";s:7:"#efefef";s:29:"admin_bar_menu_bg_hover_color";s:7:"#272a35";s:27:"admin_bar_sbmenu_link_color";s:7:"#afafaf";s:33:"admin_bar_sbmenu_link_hover_color";s:7:"#ffffff";s:16:"pry_button_color";s:7:"#239fdd";s:21:"pry_button_text_color";s:7:"#ffffff";s:22:"pry_button_hover_color";s:7:"#2091c9";s:27:"pry_button_hover_text_color";s:7:"#ffffff";s:16:"sec_button_color";s:7:"#ffffff";s:21:"sec_button_text_color";s:7:"#1e7dbc";s:22:"sec_button_hover_color";s:7:"#1e7dbc";s:27:"sec_button_hover_text_color";s:7:"#ffffff";s:16:"metabox_h3_color";s:7:"#ffffff";s:23:"metabox_h3_border_color";s:7:"#e2e7ec";s:20:"metabox_handle_color";s:7:"#8e96a0";s:26:"metabox_handle_hover_color";s:7:"#787e87";s:18:"metabox_text_color";s:7:"#8e96a0";s:13:"msg_box_color";s:7:"#3c484f";s:17:"msgbox_text_color";s:7:"#d9dfe0";s:19:"msgbox_border_color";s:7:"#239fdd";s:17:"msgbox_link_color";s:7:"#ffffff";s:23:"msgbox_link_hover_color";s:7:"#239fdd";s:14:"nav_wrap_color";s:7:"#2e363a";s:18:"sub_nav_wrap_color";s:7:"#3c484f";s:14:"nav_text_color";s:7:"#e8ebed";s:16:"hover_menu_color";s:7:"#222a2d";s:21:"menu_hover_text_color";s:7:"#f7f7f7";s:17:"active_menu_color";s:7:"#239fdd";s:22:"menu_active_text_color";s:7:"#cecece";s:25:"submenu_active_text_color";s:7:"#cecece";s:20:"menu_separator_color";s:7:"#3c484f";s:21:"menu_updates_count_bg";s:7:"#239fdd";s:23:"menu_updates_count_text";s:7:"#ffffff";}';

              $alter_themes['Full Metal'] =
              'a:52:{s:8:"bg_color";s:7:"#8b8c7a";s:8:"h1_color";s:7:"#333333";s:8:"h2_color";s:7:"#222222";s:8:"h3_color";s:7:"#222222";s:8:"h4_color";s:7:"#555555";s:8:"h5_color";s:7:"#555555";s:8:"h6_color";s:7:"#555555";s:14:"login_bg_color";s:7:"#263237";s:23:"login_inputs_text_color";s:7:"#5b5b5b";s:25:"login_inputs_border_color";s:7:"#e2e2e2";s:31:"login_inputs_border_hover_color";s:7:"#756c6c";s:18:"login_formbg_color";s:7:"#423143";s:17:"form_border_color";s:7:"#e5e5e5";s:15:"form_text_color";s:7:"#cccccc";s:15:"form_link_color";s:7:"#777777";s:21:"form_link_hover_color";s:7:"#555555";s:23:"admin_bar_logo_bg_color";s:7:"#ffffff";s:15:"admin_bar_color";s:7:"#ffffff";s:20:"admin_bar_menu_color";s:7:"#383838";s:26:"admin_bar_menu_hover_color";s:7:"#1c1c1c";s:29:"admin_bar_menu_bg_hover_color";s:7:"#eaeaea";s:27:"admin_bar_sbmenu_link_color";s:7:"#5b5b5b";s:33:"admin_bar_sbmenu_link_hover_color";s:7:"#313131";s:16:"pry_button_color";s:7:"#65675c";s:21:"pry_button_text_color";s:7:"#ffffff";s:22:"pry_button_hover_color";s:7:"#494c41";s:27:"pry_button_hover_text_color";s:7:"#f9f9f9";s:16:"sec_button_color";s:7:"#6a7262";s:21:"sec_button_text_color";s:7:"#ffffff";s:22:"sec_button_hover_color";s:7:"#52594a";s:27:"sec_button_hover_text_color";s:7:"#ffffff";s:16:"metabox_h3_color";s:7:"#efefef";s:23:"metabox_h3_border_color";s:7:"#dddddd";s:20:"metabox_handle_color";s:7:"#595959";s:26:"metabox_handle_hover_color";s:7:"#444444";s:18:"metabox_text_color";s:7:"#565656";s:13:"msg_box_color";s:7:"#afaea5";s:17:"msgbox_text_color";s:7:"#4e5647";s:19:"msgbox_border_color";s:7:"#ffffff";s:17:"msgbox_link_color";s:7:"#7e8473";s:23:"msgbox_link_hover_color";s:7:"#000000";s:14:"nav_wrap_color";s:7:"#586052";s:18:"sub_nav_wrap_color";s:7:"#656858";s:14:"nav_text_color";s:7:"#ffffff";s:16:"hover_menu_color";s:7:"#646a5c";s:21:"menu_hover_text_color";s:7:"#ffffff";s:17:"active_menu_color";s:7:"#777c63";s:22:"menu_active_text_color";s:7:"#ffffff";s:25:"submenu_active_text_color";s:7:"#cecece";s:20:"menu_separator_color";s:7:"#656858";s:21:"menu_updates_count_bg";s:7:"#42403b";s:23:"menu_updates_count_text";s:7:"#ffffff";}';

              $alter_themes['Ice Cream'] =
              'a:52:{s:8:"bg_color";s:7:"#fffec7";s:8:"h1_color";s:7:"#333333";s:8:"h2_color";s:7:"#222222";s:8:"h3_color";s:7:"#222222";s:8:"h4_color";s:7:"#555555";s:8:"h5_color";s:7:"#555555";s:8:"h6_color";s:7:"#555555";s:14:"login_bg_color";s:7:"#263237";s:23:"login_inputs_text_color";s:7:"#5b5b5b";s:25:"login_inputs_border_color";s:7:"#e2e2e2";s:31:"login_inputs_border_hover_color";s:7:"#756c6c";s:18:"login_formbg_color";s:7:"#423143";s:17:"form_border_color";s:7:"#e5e5e5";s:15:"form_text_color";s:7:"#cccccc";s:15:"form_link_color";s:7:"#777777";s:21:"form_link_hover_color";s:7:"#555555";s:23:"admin_bar_logo_bg_color";s:7:"#ffffff";s:15:"admin_bar_color";s:7:"#ffffff";s:20:"admin_bar_menu_color";s:7:"#383838";s:26:"admin_bar_menu_hover_color";s:7:"#1c1c1c";s:29:"admin_bar_menu_bg_hover_color";s:7:"#eaeaea";s:27:"admin_bar_sbmenu_link_color";s:7:"#5b5b5b";s:33:"admin_bar_sbmenu_link_hover_color";s:7:"#313131";s:16:"pry_button_color";s:7:"#694e30";s:21:"pry_button_text_color";s:7:"#ffffff";s:22:"pry_button_hover_color";s:7:"#49351f";s:27:"pry_button_hover_text_color";s:7:"#f9f9f9";s:16:"sec_button_color";s:7:"#d1bd89";s:21:"sec_button_text_color";s:7:"#422d17";s:22:"sec_button_hover_color";s:7:"#afa374";s:27:"sec_button_hover_text_color";s:7:"#ffffff";s:16:"metabox_h3_color";s:7:"#efefef";s:23:"metabox_h3_border_color";s:7:"#dddddd";s:20:"metabox_handle_color";s:7:"#595959";s:26:"metabox_handle_hover_color";s:7:"#444444";s:18:"metabox_text_color";s:7:"#565656";s:13:"msg_box_color";s:7:"#ffffff";s:17:"msgbox_text_color";s:7:"#694e30";s:19:"msgbox_border_color";s:7:"#74d976";s:17:"msgbox_link_color";s:7:"#3f301a";s:23:"msgbox_link_hover_color";s:7:"#211607";s:14:"nav_wrap_color";s:7:"#74d976";s:18:"sub_nav_wrap_color";s:7:"#5fb55e";s:14:"nav_text_color";s:7:"#ffffff";s:16:"hover_menu_color";s:7:"#aaffaa";s:21:"menu_hover_text_color";s:7:"#ffffff";s:17:"active_menu_color";s:7:"#57a353";s:22:"menu_active_text_color";s:7:"#ffffff";s:25:"submenu_active_text_color";s:7:"#cecece";s:20:"menu_separator_color";s:7:"#5fb55e";s:21:"menu_updates_count_bg";s:7:"#694e30";s:23:"menu_updates_count_text";s:7:"#ffffff";}';

              $alter_themes['Day Before Christmas'] =
              'a:52:{s:8:"bg_color";s:7:"#f2f2f2";s:8:"h1_color";s:7:"#333333";s:8:"h2_color";s:7:"#222222";s:8:"h3_color";s:7:"#222222";s:8:"h4_color";s:7:"#555555";s:8:"h5_color";s:7:"#555555";s:8:"h6_color";s:7:"#555555";s:14:"login_bg_color";s:7:"#263237";s:23:"login_inputs_text_color";s:7:"#5b5b5b";s:25:"login_inputs_border_color";s:7:"#e2e2e2";s:31:"login_inputs_border_hover_color";s:7:"#756c6c";s:18:"login_formbg_color";s:7:"#423143";s:17:"form_border_color";s:7:"#e5e5e5";s:15:"form_text_color";s:7:"#cccccc";s:15:"form_link_color";s:7:"#777777";s:21:"form_link_hover_color";s:7:"#555555";s:23:"admin_bar_logo_bg_color";s:7:"#ffffff";s:15:"admin_bar_color";s:7:"#ffffff";s:20:"admin_bar_menu_color";s:7:"#383838";s:26:"admin_bar_menu_hover_color";s:7:"#1c1c1c";s:29:"admin_bar_menu_bg_hover_color";s:7:"#eaeaea";s:27:"admin_bar_sbmenu_link_color";s:7:"#5b5b5b";s:33:"admin_bar_sbmenu_link_hover_color";s:7:"#313131";s:16:"pry_button_color";s:7:"#73172f";s:21:"pry_button_text_color";s:7:"#ffffff";s:22:"pry_button_hover_color";s:7:"#8e1632";s:27:"pry_button_hover_text_color";s:7:"#f9f9f9";s:16:"sec_button_color";s:7:"#585659";s:21:"sec_button_text_color";s:7:"#ffffff";s:22:"sec_button_hover_color";s:7:"#858087";s:27:"sec_button_hover_text_color";s:7:"#ffffff";s:16:"metabox_h3_color";s:7:"#efefef";s:23:"metabox_h3_border_color";s:7:"#dddddd";s:20:"metabox_handle_color";s:7:"#595959";s:26:"metabox_handle_hover_color";s:7:"#444444";s:18:"metabox_text_color";s:7:"#565656";s:13:"msg_box_color";s:7:"#dddddd";s:17:"msgbox_text_color";s:7:"#585659";s:19:"msgbox_border_color";s:7:"#bf0436";s:17:"msgbox_link_color";s:7:"#73172f";s:23:"msgbox_link_hover_color";s:7:"#bf0436";s:14:"nav_wrap_color";s:7:"#73172f";s:18:"sub_nav_wrap_color";s:7:"#93142e";s:14:"nav_text_color";s:7:"#ffffff";s:16:"hover_menu_color";s:7:"#bf0436";s:21:"menu_hover_text_color";s:7:"#ffffff";s:17:"active_menu_color";s:7:"#bf0436";s:22:"menu_active_text_color";s:7:"#ffffff";s:25:"submenu_active_text_color";s:7:"#cecece";s:20:"menu_separator_color";s:7:"#93142e";s:21:"menu_updates_count_bg";s:7:"#f2f2f2";s:23:"menu_updates_count_text";s:7:"#73172f";}';

              $alter_themes['Pacific Warfare'] =
              'a:52:{s:8:"bg_color";s:7:"#c0e0de";s:8:"h1_color";s:7:"#333333";s:8:"h2_color";s:7:"#222222";s:8:"h3_color";s:7:"#222222";s:8:"h4_color";s:7:"#555555";s:8:"h5_color";s:7:"#555555";s:8:"h6_color";s:7:"#555555";s:14:"login_bg_color";s:7:"#263237";s:23:"login_inputs_text_color";s:7:"#5b5b5b";s:25:"login_inputs_border_color";s:7:"#e2e2e2";s:31:"login_inputs_border_hover_color";s:7:"#756c6c";s:18:"login_formbg_color";s:7:"#423143";s:17:"form_border_color";s:7:"#e5e5e5";s:15:"form_text_color";s:7:"#cccccc";s:15:"form_link_color";s:7:"#777777";s:21:"form_link_hover_color";s:7:"#555555";s:23:"admin_bar_logo_bg_color";s:7:"#ffffff";s:15:"admin_bar_color";s:7:"#c7d6cf";s:20:"admin_bar_menu_color";s:7:"#94979b";s:26:"admin_bar_menu_hover_color";s:7:"#474747";s:29:"admin_bar_menu_bg_hover_color";s:7:"#b1bfb9";s:27:"admin_bar_sbmenu_link_color";s:7:"#6d6d6d";s:33:"admin_bar_sbmenu_link_hover_color";s:7:"#313131";s:16:"pry_button_color";s:7:"#6b84a2";s:21:"pry_button_text_color";s:7:"#ffffff";s:22:"pry_button_hover_color";s:7:"#9cb6d4";s:27:"pry_button_hover_text_color";s:7:"#000000";s:16:"sec_button_color";s:7:"#d1dade";s:21:"sec_button_text_color";s:7:"#5a5a5a";s:22:"sec_button_hover_color";s:7:"#5a5a5a";s:27:"sec_button_hover_text_color";s:7:"#d1dade";s:16:"metabox_h3_color";s:7:"#2978a0";s:23:"metabox_h3_border_color";s:7:"#ffffff";s:20:"metabox_handle_color";s:7:"#d2dac3";s:26:"metabox_handle_hover_color";s:7:"#b8c0a7";s:18:"metabox_text_color";s:7:"#ffffff";s:13:"msg_box_color";s:7:"#02c5cc";s:17:"msgbox_text_color";s:7:"#ffffff";s:19:"msgbox_border_color";s:7:"#007e87";s:17:"msgbox_link_color";s:7:"#efefef";s:23:"msgbox_link_hover_color";s:7:"#e5e5e5";s:14:"nav_wrap_color";s:7:"#171a21";s:18:"sub_nav_wrap_color";s:7:"#596070";s:14:"nav_text_color";s:7:"#90a1a8";s:16:"hover_menu_color";s:7:"#777f91";s:21:"menu_hover_text_color";s:7:"#ffffff";s:17:"active_menu_color";s:7:"#04080f";s:22:"menu_active_text_color";s:7:"#cecece";s:25:"submenu_active_text_color";s:7:"#cecece";s:20:"menu_separator_color";s:7:"#596070";s:21:"menu_updates_count_bg";s:7:"#ffffff";s:23:"menu_updates_count_text";s:7:"#212121";}';

              $alter_themes['Red Yellow'] =
              'a:52:{s:8:"bg_color";s:7:"#efeee6";s:8:"h1_color";s:7:"#333333";s:8:"h2_color";s:7:"#222222";s:8:"h3_color";s:7:"#222222";s:8:"h4_color";s:7:"#555555";s:8:"h5_color";s:7:"#555555";s:8:"h6_color";s:7:"#555555";s:14:"login_bg_color";s:7:"#263237";s:23:"login_inputs_text_color";s:7:"#5b5b5b";s:25:"login_inputs_border_color";s:7:"#e2e2e2";s:31:"login_inputs_border_hover_color";s:7:"#756c6c";s:18:"login_formbg_color";s:7:"#423143";s:17:"form_border_color";s:7:"#e5e5e5";s:15:"form_text_color";s:7:"#cccccc";s:15:"form_link_color";s:7:"#777777";s:21:"form_link_hover_color";s:7:"#555555";s:23:"admin_bar_logo_bg_color";s:7:"#ffffff";s:15:"admin_bar_color";s:7:"#ffffff";s:20:"admin_bar_menu_color";s:7:"#383838";s:26:"admin_bar_menu_hover_color";s:7:"#1c1c1c";s:29:"admin_bar_menu_bg_hover_color";s:7:"#edeaea";s:27:"admin_bar_sbmenu_link_color";s:7:"#6d6d6d";s:33:"admin_bar_sbmenu_link_hover_color";s:7:"#313131";s:16:"pry_button_color";s:7:"#dd2525";s:21:"pry_button_text_color";s:7:"#ffffff";s:22:"pry_button_hover_color";s:7:"#9b0404";s:27:"pry_button_hover_text_color";s:7:"#f9f9f9";s:16:"sec_button_color";s:7:"#eac407";s:21:"sec_button_text_color";s:7:"#a0661b";s:22:"sec_button_hover_color";s:7:"#eaca2a";s:27:"sec_button_hover_text_color";s:7:"#9b5d17";s:16:"metabox_h3_color";s:7:"#efefef";s:23:"metabox_h3_border_color";s:7:"#dddddd";s:20:"metabox_handle_color";s:7:"#595959";s:26:"metabox_handle_hover_color";s:7:"#444444";s:18:"metabox_text_color";s:7:"#565656";s:13:"msg_box_color";s:7:"#ffffff";s:17:"msgbox_text_color";s:7:"#707070";s:19:"msgbox_border_color";s:7:"#dd2525";s:17:"msgbox_link_color";s:7:"#dd2525";s:23:"msgbox_link_hover_color";s:7:"#e5d820";s:14:"nav_wrap_color";s:7:"#dd2525";s:18:"sub_nav_wrap_color";s:7:"#9b0404";s:14:"nav_text_color";s:7:"#ffffff";s:16:"hover_menu_color";s:7:"#c41313";s:21:"menu_hover_text_color";s:7:"#ffffff";s:17:"active_menu_color";s:7:"#eac407";s:22:"menu_active_text_color";s:7:"#cecece";s:25:"submenu_active_text_color";s:7:"#cecece";s:20:"menu_separator_color";s:7:"#9b0404";s:21:"menu_updates_count_bg";s:7:"#efe304";s:23:"menu_updates_count_text";s:7:"#dd2525";}';

              $alter_themes['Sunset'] =
              'a:52:{s:8:"bg_color";s:7:"#f9f9f9";s:8:"h1_color";s:7:"#333333";s:8:"h2_color";s:7:"#222222";s:8:"h3_color";s:7:"#222222";s:8:"h4_color";s:7:"#555555";s:8:"h5_color";s:7:"#555555";s:8:"h6_color";s:7:"#555555";s:14:"login_bg_color";s:7:"#263237";s:23:"login_inputs_text_color";s:7:"#5b5b5b";s:25:"login_inputs_border_color";s:7:"#e2e2e2";s:31:"login_inputs_border_hover_color";s:7:"#756c6c";s:18:"login_formbg_color";s:7:"#423143";s:17:"form_border_color";s:7:"#e5e5e5";s:15:"form_text_color";s:7:"#cccccc";s:15:"form_link_color";s:7:"#777777";s:21:"form_link_hover_color";s:7:"#555555";s:23:"admin_bar_logo_bg_color";s:7:"#ffffff";s:15:"admin_bar_color";s:7:"#ffffff";s:20:"admin_bar_menu_color";s:7:"#383838";s:26:"admin_bar_menu_hover_color";s:7:"#1c1c1c";s:29:"admin_bar_menu_bg_hover_color";s:7:"#eaeaea";s:27:"admin_bar_sbmenu_link_color";s:7:"#5b5b5b";s:33:"admin_bar_sbmenu_link_hover_color";s:7:"#313131";s:16:"pry_button_color";s:7:"#a21d1e";s:21:"pry_button_text_color";s:7:"#ffffff";s:22:"pry_button_hover_color";s:7:"#8c200f";s:27:"pry_button_hover_text_color";s:7:"#f9f9f9";s:16:"sec_button_color";s:7:"#d88e13";s:21:"sec_button_text_color";s:7:"#ffffff";s:22:"sec_button_hover_color";s:7:"#eaa21c";s:27:"sec_button_hover_text_color";s:7:"#ffffff";s:16:"metabox_h3_color";s:7:"#efefef";s:23:"metabox_h3_border_color";s:7:"#dddddd";s:20:"metabox_handle_color";s:7:"#595959";s:26:"metabox_handle_hover_color";s:7:"#444444";s:18:"metabox_text_color";s:7:"#565656";s:13:"msg_box_color";s:7:"#34bca6";s:17:"msgbox_text_color";s:7:"#ffffff";s:19:"msgbox_border_color";s:7:"#d5892b";s:17:"msgbox_link_color";s:7:"#184b4e";s:23:"msgbox_link_hover_color";s:7:"#09282b";s:14:"nav_wrap_color";s:7:"#184b4e";s:18:"sub_nav_wrap_color";s:7:"#156a6f";s:14:"nav_text_color";s:7:"#ffffff";s:16:"hover_menu_color";s:7:"#34bca6";s:21:"menu_hover_text_color";s:7:"#ffffff";s:17:"active_menu_color";s:7:"#34bca6";s:22:"menu_active_text_color";s:7:"#ffffff";s:25:"submenu_active_text_color";s:7:"#cecece";s:20:"menu_separator_color";s:7:"#156a6f";s:21:"menu_updates_count_bg";s:7:"#d58f16";s:23:"menu_updates_count_text";s:7:"#2d2d2d";}';

              $alter_themes['Kawaai'] =
              'a:52:{s:8:"bg_color";s:7:"#f2d8c9";s:8:"h1_color";s:7:"#333333";s:8:"h2_color";s:7:"#222222";s:8:"h3_color";s:7:"#222222";s:8:"h4_color";s:7:"#555555";s:8:"h5_color";s:7:"#555555";s:8:"h6_color";s:7:"#555555";s:14:"login_bg_color";s:7:"#263237";s:23:"login_inputs_text_color";s:7:"#5b5b5b";s:25:"login_inputs_border_color";s:7:"#e2e2e2";s:31:"login_inputs_border_hover_color";s:7:"#756c6c";s:18:"login_formbg_color";s:7:"#423143";s:17:"form_border_color";s:7:"#e5e5e5";s:15:"form_text_color";s:7:"#cccccc";s:15:"form_link_color";s:7:"#777777";s:21:"form_link_hover_color";s:7:"#555555";s:23:"admin_bar_logo_bg_color";s:7:"#ffffff";s:15:"admin_bar_color";s:7:"#ffffff";s:20:"admin_bar_menu_color";s:7:"#383838";s:26:"admin_bar_menu_hover_color";s:7:"#1c1c1c";s:29:"admin_bar_menu_bg_hover_color";s:7:"#eaeaea";s:27:"admin_bar_sbmenu_link_color";s:7:"#5b5b5b";s:33:"admin_bar_sbmenu_link_hover_color";s:7:"#313131";s:16:"pry_button_color";s:7:"#f25050";s:21:"pry_button_text_color";s:7:"#ffffff";s:22:"pry_button_hover_color";s:7:"#d34545";s:27:"pry_button_hover_text_color";s:7:"#f9f9f9";s:16:"sec_button_color";s:7:"#d9bb25";s:21:"sec_button_text_color";s:7:"#ffffff";s:22:"sec_button_hover_color";s:7:"#bf971f";s:27:"sec_button_hover_text_color";s:7:"#ffffff";s:16:"metabox_h3_color";s:7:"#efefef";s:23:"metabox_h3_border_color";s:7:"#dddddd";s:20:"metabox_handle_color";s:7:"#595959";s:26:"metabox_handle_hover_color";s:7:"#444444";s:18:"metabox_text_color";s:7:"#565656";s:13:"msg_box_color";s:7:"#594e45";s:17:"msgbox_text_color";s:7:"#f2d8c9";s:19:"msgbox_border_color";s:7:"#f25050";s:17:"msgbox_link_color";s:7:"#bf971f";s:23:"msgbox_link_hover_color";s:7:"#d9bb25";s:14:"nav_wrap_color";s:7:"#594e45";s:18:"sub_nav_wrap_color";s:7:"#423a32";s:14:"nav_text_color";s:7:"#ffffff";s:16:"hover_menu_color";s:7:"#d9bb25";s:21:"menu_hover_text_color";s:7:"#ffffff";s:17:"active_menu_color";s:7:"#f25050";s:22:"menu_active_text_color";s:7:"#ffffff";s:25:"submenu_active_text_color";s:7:"#cecece";s:20:"menu_separator_color";s:7:"#423a32";s:21:"menu_updates_count_bg";s:7:"#f25050";s:23:"menu_updates_count_text";s:7:"#ffffff";}';

              $alter_themes['Juicy Bubblegum'] =
              'a:52:{s:8:"bg_color";s:7:"#f9f9f9";s:8:"h1_color";s:7:"#333333";s:8:"h2_color";s:7:"#222222";s:8:"h3_color";s:7:"#222222";s:8:"h4_color";s:7:"#555555";s:8:"h5_color";s:7:"#555555";s:8:"h6_color";s:7:"#555555";s:14:"login_bg_color";s:7:"#263237";s:23:"login_inputs_text_color";s:7:"#5b5b5b";s:25:"login_inputs_border_color";s:7:"#e2e2e2";s:31:"login_inputs_border_hover_color";s:7:"#756c6c";s:18:"login_formbg_color";s:7:"#423143";s:17:"form_border_color";s:7:"#e5e5e5";s:15:"form_text_color";s:7:"#cccccc";s:15:"form_link_color";s:7:"#777777";s:21:"form_link_hover_color";s:7:"#555555";s:23:"admin_bar_logo_bg_color";s:7:"#ffffff";s:15:"admin_bar_color";s:7:"#ffffff";s:20:"admin_bar_menu_color";s:7:"#383838";s:26:"admin_bar_menu_hover_color";s:7:"#1c1c1c";s:29:"admin_bar_menu_bg_hover_color";s:7:"#edeaea";s:27:"admin_bar_sbmenu_link_color";s:7:"#6d6d6d";s:33:"admin_bar_sbmenu_link_hover_color";s:7:"#313131";s:16:"pry_button_color";s:7:"#e02657";s:21:"pry_button_text_color";s:7:"#ffffff";s:22:"pry_button_hover_color";s:7:"#e00f47";s:27:"pry_button_hover_text_color";s:7:"#f9f9f9";s:16:"sec_button_color";s:7:"#04abf2";s:21:"sec_button_text_color";s:7:"#effffb";s:22:"sec_button_hover_color";s:7:"#0485db";s:27:"sec_button_hover_text_color";s:7:"#ffffff";s:16:"metabox_h3_color";s:7:"#efefef";s:23:"metabox_h3_border_color";s:7:"#dddddd";s:20:"metabox_handle_color";s:7:"#595959";s:26:"metabox_handle_hover_color";s:7:"#444444";s:18:"metabox_text_color";s:7:"#565656";s:13:"msg_box_color";s:7:"#ffffff";s:17:"msgbox_text_color";s:7:"#707070";s:19:"msgbox_border_color";s:7:"#e02657";s:17:"msgbox_link_color";s:7:"#0a0a0a";s:23:"msgbox_link_hover_color";s:7:"#04abf2";s:14:"nav_wrap_color";s:7:"#282828";s:18:"sub_nav_wrap_color";s:7:"#3d3d3d";s:14:"nav_text_color";s:7:"#ffffff";s:16:"hover_menu_color";s:7:"#3d3d3d";s:21:"menu_hover_text_color";s:7:"#ffffff";s:17:"active_menu_color";s:7:"#e02657";s:22:"menu_active_text_color";s:7:"#cecece";s:25:"submenu_active_text_color";s:7:"#cecece";s:20:"menu_separator_color";s:7:"#3d3d3d";s:21:"menu_updates_count_bg";s:7:"#04abf2";s:23:"menu_updates_count_text";s:7:"#ffffff";}';

              $alter_themes['Sun'] =
              'a:52:{s:8:"bg_color";s:7:"#dfddde";s:8:"h1_color";s:7:"#333333";s:8:"h2_color";s:7:"#222222";s:8:"h3_color";s:7:"#222222";s:8:"h4_color";s:7:"#555555";s:8:"h5_color";s:7:"#555555";s:8:"h6_color";s:7:"#555555";s:14:"login_bg_color";s:7:"#263237";s:23:"login_inputs_text_color";s:7:"#5b5b5b";s:25:"login_inputs_border_color";s:7:"#e2e2e2";s:31:"login_inputs_border_hover_color";s:7:"#756c6c";s:18:"login_formbg_color";s:7:"#423143";s:17:"form_border_color";s:7:"#e5e5e5";s:15:"form_text_color";s:7:"#cccccc";s:15:"form_link_color";s:7:"#777777";s:21:"form_link_hover_color";s:7:"#555555";s:23:"admin_bar_logo_bg_color";s:7:"#ffffff";s:15:"admin_bar_color";s:7:"#ffffff";s:20:"admin_bar_menu_color";s:7:"#383838";s:26:"admin_bar_menu_hover_color";s:7:"#1c1c1c";s:29:"admin_bar_menu_bg_hover_color";s:7:"#eaeaea";s:27:"admin_bar_sbmenu_link_color";s:7:"#5b5b5b";s:33:"admin_bar_sbmenu_link_hover_color";s:7:"#313131";s:16:"pry_button_color";s:7:"#a01b14";s:21:"pry_button_text_color";s:7:"#ffffff";s:22:"pry_button_hover_color";s:7:"#7f0b0b";s:27:"pry_button_hover_text_color";s:7:"#f9f9f9";s:16:"sec_button_color";s:7:"#e15829";s:21:"sec_button_text_color";s:7:"#ffffff";s:22:"sec_button_hover_color";s:7:"#bf5922";s:27:"sec_button_hover_text_color";s:7:"#ffffff";s:16:"metabox_h3_color";s:7:"#efefef";s:23:"metabox_h3_border_color";s:7:"#dddddd";s:20:"metabox_handle_color";s:7:"#595959";s:26:"metabox_handle_hover_color";s:7:"#444444";s:18:"metabox_text_color";s:7:"#565656";s:13:"msg_box_color";s:7:"#6a5052";s:17:"msgbox_text_color";s:7:"#dfddde";s:19:"msgbox_border_color";s:7:"#e15829";s:17:"msgbox_link_color";s:7:"#c4bab0";s:23:"msgbox_link_hover_color";s:7:"#ffffff";s:14:"nav_wrap_color";s:7:"#f0ad25";s:18:"sub_nav_wrap_color";s:7:"#6a5052";s:14:"nav_text_color";s:7:"#ffffff";s:16:"hover_menu_color";s:7:"#a01b14";s:21:"menu_hover_text_color";s:7:"#ffffff";s:17:"active_menu_color";s:7:"#e15829";s:22:"menu_active_text_color";s:7:"#ffffff";s:25:"submenu_active_text_color";s:7:"#cecece";s:20:"menu_separator_color";s:7:"#6a5052";s:21:"menu_updates_count_bg";s:7:"#7f1c0b";s:23:"menu_updates_count_text";s:7:"#ffffff";}';

              return $alter_themes;
            }

}

new ALTERTHENES();
